
<?php $__env->startSection('content'); ?>
<div class="main-content app-content">
    <div class="container-fluid">

        <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
            <div>
                <h1 class="page-title fw-medium fs-18 mb-2"><?php echo e($course->title); ?></h1>
                <?php if(!empty($course->description)): ?>
                <p class="text-muted mb-0"><?php echo e($course->description); ?></p>
                <?php endif; ?>
            </div>
            <div>
                <a href="<?php echo e(route('driver.courses')); ?>" class="btn btn-secondary">Back</a>
            </div>
        </div>

        <div class="card custom-card">
            <div class="card-body">

                
                <ul class="nav nav-tabs mb-3" role="tablist">

                    <?php
                    $hasVideo = !empty($course->video_url);
                    $hasText = !empty($course->transcript) || !empty($course->description);
                    $hasDownload = !empty($course->slides_url) || $course->slides_url != "";
                    $hasDownload = isset($course->files) && count($course->files) > 0;
                    $firstTab = $hasVideo ? 'video' : ($hasText ? 'text' : ($hasDownload ? 'downloads' : 'text' ($course->has_quiz ? 'quiz' : 'text')));
                    ?>

                    <?php if($hasVideo): ?>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link <?php echo e($firstTab == 'video' ? 'active' : ''); ?>" data-bs-toggle="tab"
                            data-bs-target="#tab-video" type="button">
                            Video
                        </button>
                    </li>
                    <?php endif; ?>

                    <?php if($hasText): ?>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link <?php echo e($firstTab == 'text' ? 'active' : ''); ?>" data-bs-toggle="tab"
                            data-bs-target="#tab-text" type="button">
                            Text
                        </button>
                    </li>
                    <?php endif; ?>

                    <?php if($hasDownload): ?>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link <?php echo e($firstTab == 'downloads' ? 'active' : ''); ?>" data-bs-toggle="tab"
                            data-bs-target="#tab-downloads" type="button">
                            Downloads
                        </button>
                    </li>
                    <?php endif; ?>
                    
                    <?php if($course->has_quiz && $quiz->count()): ?>
                    <li class="nav-item">
                        <button class="nav-link <?php echo e($firstTab == 'quiz' ? 'active' : ''); ?>"
                            data-bs-toggle="tab" data-bs-target="#tab-quiz">
                            Quiz
                        </button>
                    </li>
                    <?php endif; ?>


                </ul>

                <div class="tab-content">

                    
                    <?php if($hasVideo): ?>
                    <div class="tab-pane fade <?php echo e($firstTab == 'video' ? 'show active' : ''); ?>" id="tab-video">
                        <div class="ratio ratio-16x9">

                            <?php if(Str::contains($course->video_url, 'youtube.com') || Str::contains($course->video_url, 'youtu.be')): ?>
                            <iframe src="https://www.youtube.com/embed/<?php echo e(Str::afterLast($course->video_url, '/')); ?>"
                                title="Course Video" frameborder="0" allowfullscreen>
                            </iframe>
                            <?php else: ?>
                            <video controls>
                                <source src="<?php echo e($course->video_url); ?>" type="video/mp4">
                                Your browser does not support the video tag.
                            </video>
                            <?php endif; ?>

                        </div>
                    </div>
                    <?php endif; ?>

                    
                    <?php if($hasText): ?>
                    <div class="tab-pane fade <?php echo e($firstTab == 'text' ? 'show active' : ''); ?>" id="tab-text">

                        <div class="d-flex gap-2 mb-3">
                            <button type="button" id="ttsGenerateBtn" class="btn btn-primary btn-sm">
                                Generate Speech
                            </button>

                            <button type="button" id="ttsPlayBtn" class="btn btn-success btn-sm" disabled>
                                Play
                            </button>

                            <button type="button" id="ttsPauseBtn" class="btn btn-warning btn-sm" disabled>
                                Pause
                            </button>
                        </div>

                        <audio id="ttsAudio" class="w-100" controls style="display:none;"></audio>

                        <div class="p-3 border rounded" id="ttsText">
                            <?php if(!empty($course->transcript)): ?>
                            <?php echo $course->transcript; ?>

                            <?php else: ?>
                            <?php echo nl2br(e($course->description)); ?>

                            <?php endif; ?>
                        </div>

                    </div>
                    <?php endif; ?>

                    
                    <?php if($hasDownload): ?>
                    <div class="tab-pane fade <?php echo e($firstTab == 'downloads' ? 'show active' : ''); ?>" id="tab-downloads">
                        <?php if(empty($course->slides_url) || $course->slides_url != ""): ?>
                        <a href="<?php echo e($course->slides_url); ?>" target="_blank" class="btn mb-2 btn-outline-primary btn-sm">
                            Download Slides
                        </a>
                        <?php $__currentLoopData = $course->files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="mb-2">
                            <a href="<?php echo e(asset('storage/' . $file->file_path)); ?>" target="_blank"
                                class="btn btn-outline-primary btn-sm">
                                <?php echo e($file->file_name); ?>

                            </a>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>


                    <?php endif; ?>
                    <?php if(!$hasVideo && !$hasText && !$hasDownload): ?>
                    <div class="alert alert-warning mb-0">Content not available for this course yet.</div>
                    <?php endif; ?>

                    
                    <?php if($course->has_quiz && $quiz->count()): ?>
                    <div class="tab-pane fade <?php echo e($firstTab == 'quiz' ? 'show active' : ''); ?>" id="tab-quiz">

                        <div class="card p-4">
                            <h5 class="mb-4">
                                <i class="bi bi-question-circle"></i> Quiz
                            </h5>
                            <form method="POST" action="<?php echo e(route('quiz.submit')); ?>">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="course_id" value="<?php echo e($course->id); ?>">

                                <?php $__currentLoopData = $quiz; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="mb-4">
                                    <h6>Q<?php echo e($index+1); ?>. <?php echo e($question->question_text); ?></h6>

                                    <?php $__currentLoopData = $question->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-check mb-2">
                                        <input class="form-check-input"
                                            type="<?php echo e($question->question_type == 'multi_select' ? 'checkbox' : 'radio'); ?>"
                                            name="answers[<?php echo e($question->id); ?>]<?php echo e($question->question_type == 'multi_select' ? '[]' : ''); ?>"
                                            value="<?php echo e($opt->id); ?>">
                                        <label class="form-check-label">
                                            <?php echo e($opt->option_text); ?>

                                        </label>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <hr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <div class="text-end">
                                    <button class="btn btn-primary">Submit Quiz</button>
                                </div>
                            </form>
                        </div>

                    </div>
                    <?php endif; ?>

                </div>

            </div>
        </div>

    </div>
</div>
<?php $__env->startSection('scripts'); ?>
<script>
    const ttsAudio = document.getElementById('ttsAudio');
    const ttsGenerateBtn = document.getElementById('ttsGenerateBtn');
    const ttsPlayBtn = document.getElementById('ttsPlayBtn');
    const ttsPauseBtn = document.getElementById('ttsPauseBtn');

    let lastAudioUrl = null;

    function setButtons(isReady, isLoading = false) {
        ttsGenerateBtn.disabled = isLoading;
        ttsPlayBtn.disabled = !isReady;
        ttsPauseBtn.disabled = !isReady;
    }

    function getTTSText() {
        const el = document.getElementById('ttsText');
        return (el?.innerText || '').trim();
    }

    ttsGenerateBtn.addEventListener('click', function() {
        const text = getTTSText();
        if (!text) return notify('danger', 'No text available.');

        setButtons(false, true);

        $.ajax({
            url: "<?php echo e(route('driver.tts')); ?>",
            method: "POST",
            headers: {
                "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>"
            },
            data: {
                text: text
            },
            xhrFields: {
                responseType: 'blob'
            },
            success: function(blob, status, xhr) {

                // If backend returned JSON error as blob, detect it
                const ct = (xhr.getResponseHeader('Content-Type') || '').toLowerCase();

                if (ct.includes('application/json')) {
                    const reader = new FileReader();
                    reader.onload = function() {
                        try {
                            const json = JSON.parse(reader.result);
                            alert(json.msg || 'TTS error');
                        } catch (e) {
                            notify('danger', 'TTS error');
                        }
                        setButtons(false, false);
                    };
                    reader.readAsText(blob);
                    return;
                }

                if (blob.size < 1000) {
                    setButtons(false, false);
                    notify('danger', 'Audio is empty. Check API key / voice_id / balance.');
                    return;
                }

                if (lastAudioUrl) URL.revokeObjectURL(lastAudioUrl);
                lastAudioUrl = URL.createObjectURL(blob);

                ttsAudio.src = lastAudioUrl;
                ttsAudio.style.display = "block";

                setButtons(true, false);
                ttsAudio.play().catch(() => {});
            },
            error: function() {
                setButtons(false, false);
                notify('danger', 'Failed to generate speech.');
            }
        });
    });

    ttsPlayBtn.addEventListener('click', function() {
        if (ttsAudio.src) ttsAudio.play().catch(() => {});
    });
    ttsPauseBtn.addEventListener('click', function() {
        ttsAudio.pause();
    });

    setButtons(false, false);
</script>

<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('driver.layout.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\www\thirdot-misbah\lms-lms\resources\views/driver/courses/single-show.blade.php ENDPATH**/ ?>