
<?php $__env->startSection('content'); ?>
    <div class="main-content app-content">
        <div class="container-fluid">

            <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
                <div>
                    <h1 class="page-title fw-medium fs-18 mb-2"><?php echo e($title); ?></h1>
                </div>
                <div class="d-flex gap-2 align-items-center">
                    <a href="<?php echo e(Route('admin.child-service-details')); ?>" class="btn btn-primary">
                        Add Child Service-details
                    </a>

                    <button type="button" data-bs-toggle="modal" data-bs-target="#add-modal" class="btn btn-primary">
                        Add Child Service
                    </button>
                </div>
            </div>

            <div class="row">
                <div class="col-xl-12">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="data-table" class="table table-bordered text-nowrap w-100">
                                    <thead>
                                        <tr>
                                            <th>Sno</th>
                                            <th>Service Title</th>
                                            <th>Name</th>
                                            <th>Short Description</th>
                                            <th>Description</th>
                                            <th>Image</th>
                                            <th>Stauts</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="add-modal" tabindex="-1" aria-labelledby="add-modal" data-bs-keyboard="false"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title" id="staticBackdropLabel2">Add <?php echo e($title); ?></h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="add-form" data-parsley-validate data-url="<?php echo e(route('admin.add_edit_child_service')); ?>">
                        <div class="form-group mb-3">
                            <label for="floatingInput">Select Service<span class="text-danger">*</span></label>
                            <select class="form-control" id="service_id" data-toggle="select2"
                                data-placeholder="Select Service" name="service_id" aria-hidden="true">
                                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($service->id); ?>"><?php echo e($service->title); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group mb-3">
                            <label for="floatingInput">Name <span class="text-danger">*</span></label>
                            <input type="text" placeholder="Name" minlength="3" maxlength="50" name="name"
                                class="form-control" id="name" required="true">
                        </div>
                        <div class="form-group mb-3">
                            <label for="floatingInput">Select Image<span class="text-danger">*</span></label>
                            <input type="file" name="image" class="form-control" id="image" required="true">
                        </div>
                        <div class="form-group mb-3">
                            <label for="floatingInput">Short Description <span class="text-danger">*</span></label>
                            <textarea name="short_description" class="form-control" placeholder="Short Description"
                                id="short_description" required minlength="10"></textarea>
                        </div>
                        <div class="form-group mb-3">
                            <label for="floatingInput">Description <span class="text-danger">*</span></label>
                            <textarea name="description" class="form-control" placeholder="Description" id="description"
                                required minlength="10"></textarea>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" id="add-btn" onclick="save_form(event,this)"
                        class="btn btn-primary">Submit</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="edit-modal" tabindex="-1" aria-labelledby="add-modal" data-bs-keyboard="false"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title" id="staticBackdropLabel2">Edit <?php echo e($title); ?></h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="edit-form" data-parsley-validate>

                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" id="update-btn" onclick="update_form(event,this)"
                        class="btn btn-primary">Submit</button>
                </div>
            </div>
        </div>
    </div>
    <?php $__env->startSection('scripts'); ?>
        <script src="<?php echo e(asset('admin/custom-js/modules-helper.js')); ?>"></script>
        <script src="<?php echo e(asset('admin/custom-js/modules.js')); ?>"></script>
    <?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\thirdot\resources\views/admin/sp-modules/child-services.blade.php ENDPATH**/ ?>