
<?php $__env->startSection('content'); ?>
<main>
    <?php
        use Illuminate\Support\Str;
    ?>
    <!-- Breadcrumb area start -->
    <div class="breadcrumb__area theme-bg-1 p-relative pt-160 pb-160">
        <div class="breadcrumb__thumb" data-background="<?php echo e(asset('website/imgs/banner/about4.jpg')); ?>"></div>
        <!-- <div class="breadcrumb__thumb_2" data-background="<?php echo e(asset('website/imgs/resources/page-title-bg-2.png')); ?>"></div> -->
        <div class="small-container">
            <div class="row justify-content-center">
                <div class="col-xxl-12">
                    <div class="breadcrumb__wrapper p-relative">
                        <h2 class="breadcrumb__title">Blogs</h2>
                        <div class="breadcrumb__menu">
                            <nav>
                                <ul>
                                    <li><span><a href="<?php echo e(Route('site.home')); ?>">Home</a></span></li>
                                    <li><span>Blogs</span></li>
                                </ul>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb area end -->

    <!-- Blog area start -->
    <section class="blog-section-one section-space">
        <div class="small-container">
            <div class="row g-4">
                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xxl-4 col-xl-4 col-lg-6 mb-15">
                    <div class="blog-style-one">
                        <a class="blog-image w-img" href="<?php echo e(route('site.blog.details', ['slug' => Str::slug($blog->title)])); ?>">
                            <img src="<?php echo e(asset('images/blogs/'.$blog->thumbnail)); ?>" alt="<?php echo e($blog->title); ?>">
                        </a>
                        <div class="blog-content">
                            <div class="post-meta">
                                <span class="p-relative">
                                    <a href="<?php echo e(route('site.blog.details', ['slug' => Str::slug($blog->title)])); ?>">
                                        <i class="fal fa-user"></i> By <?php echo e($blog->author ?? 'Admin'); ?>

                                    </a>
                                </span>
                                <span class="p-relative">
                                    <a href="<?php echo e(route('site.blog.details', ['slug' => Str::slug($blog->title)])); ?>">
                                        <i class="fal fa-calendar-alt"></i>
                                        <?php echo e(\Carbon\Carbon::parse($blog->created_at)->format('d F, Y')); ?>

                                    </a>
                                </span>
                            </div>
                            <hr>
                            <h5 class="blog-title mb-10">
                                <a href="<?php echo e(route('site.blog.details', ['slug' => Str::slug($blog->title)])); ?>"><?php echo e($blog->title); ?></a>
                            </h5>
                            <p>
                                <?php echo e(Str::limit($blog->short_desc ?? 'Stay updated with latest trends and insightful tips.', 50)); ?>

                            </p>
                            <div class="blog-link mt-15">
                                <a class="primary-btn-5 btn-hover" href="<?php echo e(route('site.blog.details', ['slug' => Str::slug($blog->title)])); ?>">
                                    Read MORE &nbsp; | <i class="icon-right-arrow"></i>
                                    <span></span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            
            <div class="row">
                <div class="col-xxl-12">
                    <div class="pagination__wrapper mt-50">
                        <div class="bd-basic__pagination d-flex align-items-center justify-content-center">
                            <?php echo e($blogs->links('pagination::custom')); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('website.layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\thirdot\resources\views/website/content/blog.blade.php ENDPATH**/ ?>