<?php

use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\CourseController;
use App\Http\Controllers\Admin\CrudController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\QuizController;
use App\Http\Controllers\Dirver\CoursesListCountroller;
use App\Http\Controllers\Dirver\DriverDashCountroller;
use App\Http\Controllers\Dirver\TextToSpeachController;
use Illuminate\Support\Facades\Route;

Route::prefix('/lms/')->group(function () {
    Route::controller(AuthController::class)->group(function () {
        // Route::match(['get', 'post'], '/login', 'login')->name('admin.login')->middleware('admin.guest');
        Route::match(['get', 'post'], '/login', 'login')->name('admin.login');
    });
    Route::prefix('/management/')->group(function () {
        Route::middleware('admin.auth')->group(function () {
            Route::controller(DashboardController::class)->group(function () {
                Route::match(['get', 'post'], '/dashboard', 'dashboard')->name('admin.dashboard');
                Route::get('/logout', 'logout')->name('admin.logout');
            });
            Route::controller(CrudController::class)->group(function () {
                Route::match(['get', 'post'], '/users', 'users')->name('users.index');
                Route::match(['get', 'post'], '/add-edit-user/{id?}', 'add_edit_user')->name('users.add_edit');

                Route::match(['get', 'post'], '/programs', 'programs')->name('programs.index');
                Route::match(['get', 'post'], '/add-edit-program/{id?}', 'add_edit_program')->name('programs.add_edit');
            });
            Route::controller(CourseController::class)->group(function () {
                Route::match(['get', 'post'], '/courses', 'index')->name('courses.index');

                Route::get('/courses/add', 'create')->name('courses.add');
                Route::post('/courses/add', 'store')->name('courses.store');

                Route::get('/courses/edit/{id}', 'edit')->name('courses.edit');
                Route::post('/courses/edit/{id}', 'update')->name('courses.update');
            });
            Route::controller(QuizController::class)->group(function () {
                Route::match(['get', 'post'], '/quiz-questions', 'index')->name('quiz_question.index');

                Route::get('/quiz-questions/add', 'create')->name('quiz_question.add');
                Route::post('/quiz-questions/add', 'store')->name('quiz_question.store');

                Route::get('/quiz-questions/edit/{id}', 'edit')->name('quiz_question.edit');
                Route::post('/quiz-questions/edit/{id}', 'update')->name('quiz_question.update');
            });
        });
    });
    
    Route::middleware('driver.auth')->group(function () {
        Route::controller(DriverDashCountroller::class)->group(function () {
            Route::match(['get', 'post'], '/dashboard', 'dashboard')->name('driver.dashboard');
            Route::get('/logout', 'logout')->name('admin.logout');
        });
        Route::controller(CoursesListCountroller::class)->group(function () {
            Route::get('courses/{id?}', 'courses')->name('driver.courses');
        });
        Route::post('/tts',[TextToSpeachController::class,'tts'])->name('driver.tts');
    });
    Route::post('/quiz-submit', action: [CoursesListCountroller::class, 'submitQuiz'])->name('quiz.submit');
});
