@if ($paginator->hasPages())
    <div class="row">
        <div class="col-xxl-12">
            <div class="pagination__wrapper mt-50">
                <div class="bd-basic__pagination d-flex align-items-center justify-content-center">
                    <nav>
                        <ul>
                            {{-- Previous Page Link --}}
                            @if ($paginator->onFirstPage())
                                <li class="disabled"><span><i class="far fa-arrow-left"></i></span></li>
                            @else
                                <li>
                                    <a href="{{ $paginator->previousPageUrl() }}"><i class="far fa-arrow-left"></i></a>
                                </li>
                            @endif

                            {{-- Pagination Elements --}}
                            @foreach ($elements as $element)
                                {{-- "Three Dots" Separator --}}
                                @if (is_string($element))
                                    <li class="disabled"><span>{{ $element }}</span></li>
                                @endif

                                {{-- Array Of Links --}}
                                @if (is_array($element))
                                    @foreach ($element as $page => $url)
                                        @if ($page == $paginator->currentPage())
                                            <li class="current"><a href="#">{{ $page }}</a></li>
                                        @else
                                            <li><a href="{{ $url }}">{{ $page }}</a></li>
                                        @endif
                                    @endforeach
                                @endif
                            @endforeach

                            {{-- Next Page Link --}}
                            @if ($paginator->hasMorePages())
                                <li>
                                    <a href="{{ $paginator->nextPageUrl() }}"><i class="far fa-arrow-right"></i></a>
                                </li>
                            @else
                                <li class="disabled"><span><i class="far fa-arrow-right"></i></span></li>
                            @endif
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>
@endif
