@extends('driver.layout.main')
@section('content')
<div class="main-content app-content">
    <div class="container-fluid">

        <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
            <div>
                <h1 class="page-title fw-medium fs-18 mb-2">{{ $course->title }}</h1>
                @if(!empty($course->description))
                <p class="text-muted mb-0">{{ $course->description }}</p>
                @endif
            </div>
            <div>
                <a href="{{ route('driver.courses') }}" class="btn btn-secondary">Back</a>
            </div>
        </div>

        <div class="card custom-card">
            <div class="card-body">

                {{-- Tabs --}}
                <ul class="nav nav-tabs mb-3" role="tablist">

                    @php
                    $hasVideo = !empty($course->video_url);
                    $hasText = !empty($course->transcript) || !empty($course->description);
                    $hasDownload = !empty($course->slides_url) || $course->slides_url != "";
                    $hasDownload = isset($course->files) && count($course->files) > 0;
                    $firstTab = $hasVideo ? 'video' : ($hasText ? 'text' : ($hasDownload ? 'downloads' : 'text' ($course->has_quiz ? 'quiz' : 'text')));
                    @endphp

                    @if($hasVideo)
                    <li class="nav-item" role="presentation">
                        <button class="nav-link {{ $firstTab == 'video' ? 'active' : '' }}" data-bs-toggle="tab"
                            data-bs-target="#tab-video" type="button">
                            Video
                        </button>
                    </li>
                    @endif

                    @if($hasText)
                    <li class="nav-item" role="presentation">
                        <button class="nav-link {{ $firstTab == 'text' ? 'active' : '' }}" data-bs-toggle="tab"
                            data-bs-target="#tab-text" type="button">
                            Text
                        </button>
                    </li>
                    @endif

                    @if($hasDownload)
                    <li class="nav-item" role="presentation">
                        <button class="nav-link {{ $firstTab == 'downloads' ? 'active' : '' }}" data-bs-toggle="tab"
                            data-bs-target="#tab-downloads" type="button">
                            Downloads
                        </button>
                    </li>
                    @endif
                    {{-- ✅ QUIZ TAB BUTTON --}}
                    @if($course->has_quiz && $quiz->count())
                    <li class="nav-item">
                        <button class="nav-link {{ $firstTab == 'quiz' ? 'active' : '' }}"
                            data-bs-toggle="tab" data-bs-target="#tab-quiz">
                            Quiz
                        </button>
                    </li>
                    @endif


                </ul>

                <div class="tab-content">

                    {{-- VIDEO --}}
                    @if($hasVideo)
                    <div class="tab-pane fade {{ $firstTab == 'video' ? 'show active' : '' }}" id="tab-video">
                        <div class="ratio ratio-16x9">

                            @if(Str::contains($course->video_url, 'youtube.com') || Str::contains($course->video_url, 'youtu.be'))
                            <iframe src="https://www.youtube.com/embed/{{ Str::afterLast($course->video_url, '/') }}"
                                title="Course Video" frameborder="0" allowfullscreen>
                            </iframe>
                            @else
                            <video controls>
                                <source src="{{ $course->video_url }}" type="video/mp4">
                                Your browser does not support the video tag.
                            </video>
                            @endif

                        </div>
                    </div>
                    @endif

                    {{-- TEXT --}}
                    @if($hasText)
                    <div class="tab-pane fade {{ $firstTab == 'text' ? 'show active' : '' }}" id="tab-text">

                        <div class="d-flex gap-2 mb-3">
                            <button type="button" id="ttsGenerateBtn" class="btn btn-primary btn-sm">
                                Generate Speech
                            </button>

                            <button type="button" id="ttsPlayBtn" class="btn btn-success btn-sm" disabled>
                                Play
                            </button>

                            <button type="button" id="ttsPauseBtn" class="btn btn-warning btn-sm" disabled>
                                Pause
                            </button>
                        </div>

                        <audio id="ttsAudio" class="w-100" controls style="display:none;"></audio>

                        <div class="p-3 border rounded" id="ttsText">
                            @if(!empty($course->transcript))
                            {!! $course->transcript !!}
                            @else
                            {!! nl2br(e($course->description)) !!}
                            @endif
                        </div>

                    </div>
                    @endif

                    {{-- DOWNLOADS --}}
                    @if($hasDownload)
                    <div class="tab-pane fade {{ $firstTab == 'downloads' ? 'show active' : '' }}" id="tab-downloads">
                        @if(empty($course->slides_url) || $course->slides_url != "")
                        <a href="{{ $course->slides_url }}" target="_blank" class="btn mb-2 btn-outline-primary btn-sm">
                            Download Slides
                        </a>
                        @foreach ($course->files as $file)
                        <div class="mb-2">
                            <a href="{{ asset('storage/' . $file->file_path) }}" target="_blank"
                                class="btn btn-outline-primary btn-sm">
                                {{ $file->file_name }}
                            </a>
                        </div>
                        @endforeach
                        @endif
                    </div>


                    @endif
                    @if(!$hasVideo && !$hasText && !$hasDownload)
                    <div class="alert alert-warning mb-0">Content not available for this course yet.</div>
                    @endif

                    {{-- QUIZ CONTENT --}}
                    @if($course->has_quiz && $quiz->count())
                    <div class="tab-pane fade {{ $firstTab == 'quiz' ? 'show active' : '' }}" id="tab-quiz">

                        <div class="card p-4">
                            <h5 class="mb-4">
                                <i class="bi bi-question-circle"></i> Quiz
                            </h5>
                            <form method="POST" action="{{ route('quiz.submit') }}">
                                @csrf
                                <input type="hidden" name="course_id" value="{{ $course->id }}">

                                @foreach($quiz as $index => $question)
                                <div class="mb-4">
                                    <h6>Q{{ $index+1 }}. {{ $question->question_text }}</h6>

                                    @foreach($question->options as $opt)
                                    <div class="form-check mb-2">
                                        <input class="form-check-input"
                                            type="{{ $question->question_type == 'multi_select' ? 'checkbox' : 'radio' }}"
                                            name="answers[{{ $question->id }}]{{ $question->question_type == 'multi_select' ? '[]' : '' }}"
                                            value="{{ $opt->id }}">
                                        <label class="form-check-label">
                                            {{ $opt->option_text }}
                                        </label>
                                    </div>
                                    @endforeach
                                </div>
                                <hr>
                                @endforeach

                                <div class="text-end">
                                    <button class="btn btn-primary">Submit Quiz</button>
                                </div>
                            </form>
                        </div>

                    </div>
                    @endif

                </div>

            </div>
        </div>

    </div>
</div>
@section('scripts')
<script>
    const ttsAudio = document.getElementById('ttsAudio');
    const ttsGenerateBtn = document.getElementById('ttsGenerateBtn');
    const ttsPlayBtn = document.getElementById('ttsPlayBtn');
    const ttsPauseBtn = document.getElementById('ttsPauseBtn');

    let lastAudioUrl = null;

    function setButtons(isReady, isLoading = false) {
        ttsGenerateBtn.disabled = isLoading;
        ttsPlayBtn.disabled = !isReady;
        ttsPauseBtn.disabled = !isReady;
    }

    function getTTSText() {
        const el = document.getElementById('ttsText');
        return (el?.innerText || '').trim();
    }

    ttsGenerateBtn.addEventListener('click', function() {
        const text = getTTSText();
        if (!text) return notify('danger', 'No text available.');

        setButtons(false, true);

        $.ajax({
            url: "{{ route('driver.tts') }}",
            method: "POST",
            headers: {
                "X-CSRF-TOKEN": "{{ csrf_token() }}"
            },
            data: {
                text: text
            },
            xhrFields: {
                responseType: 'blob'
            },
            success: function(blob, status, xhr) {

                // If backend returned JSON error as blob, detect it
                const ct = (xhr.getResponseHeader('Content-Type') || '').toLowerCase();

                if (ct.includes('application/json')) {
                    const reader = new FileReader();
                    reader.onload = function() {
                        try {
                            const json = JSON.parse(reader.result);
                            alert(json.msg || 'TTS error');
                        } catch (e) {
                            notify('danger', 'TTS error');
                        }
                        setButtons(false, false);
                    };
                    reader.readAsText(blob);
                    return;
                }

                if (blob.size < 1000) {
                    setButtons(false, false);
                    notify('danger', 'Audio is empty. Check API key / voice_id / balance.');
                    return;
                }

                if (lastAudioUrl) URL.revokeObjectURL(lastAudioUrl);
                lastAudioUrl = URL.createObjectURL(blob);

                ttsAudio.src = lastAudioUrl;
                ttsAudio.style.display = "block";

                setButtons(true, false);
                ttsAudio.play().catch(() => {});
            },
            error: function() {
                setButtons(false, false);
                notify('danger', 'Failed to generate speech.');
            }
        });
    });

    ttsPlayBtn.addEventListener('click', function() {
        if (ttsAudio.src) ttsAudio.play().catch(() => {});
    });
    ttsPauseBtn.addEventListener('click', function() {
        ttsAudio.pause();
    });

    setButtons(false, false);
</script>

@endsection
@endsection