@extends('driver.layout.main')
@section('content')
<div class="main-content app-content">
    <div class="container-fluid p-4">
        <h4 class="mb-3">Quiz Result</h4>

        <div class="alert alert-success">
            ✅ Correct: <strong>{{ $correct }}</strong>
        </div>

        <div class="alert alert-danger">
            ❌ Wrong: <strong>{{ $wrong }}</strong>
        </div>

        <div class="alert alert-info">
            📊 Total Questions: <strong>{{ $total }}</strong>
        </div>
        <hr>
        <h5>Question-wise Report</h5>
        <ul class="list-group">
            @foreach($details as $item)
            <li class="list-group-item d-flex justify-content-between">
                <span>{{ $item['question'] }}</span>
                <span class="badge {{ $item['status'] == 'Correct' ? 'bg-success' : 'bg-danger' }}">
                    {{ $item['status'] }}
                </span>
            </li>
            @endforeach
        </ul>
        <div class="alert alert-primary mt-3">
            🎯 Score: <strong>{{ $earnedPoints }}</strong> / {{ $totalPoints }}
        </div>

        <div class="alert alert-info">
            📈 Percentage: <strong>{{ $percentage }}%</strong>
        </div>

        <div class="alert {{ $resultStatus == 'PASS' ? 'alert-success' : 'alert-danger' }}">
            🏆 Result:
            <strong>
                {{ $resultStatus }}
            </strong>
            (Passing: {{ $passingPercent }}%)
        </div>

        <div class="mt-3" id="re-attemt">
            <button type="button" class="btn btn-primary">Re Attempet</button>
        </div>
    </div>
</div>
@endsection