@extends('driver.layout.main')
@section('content')
<div class="main-content app-content">
    <div class="container-fluid">

        <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
            <div>
                <h1 class="page-title fw-medium fs-18 mb-2">{{ $title }}</h1>
            </div>
        </div>

        @if($courses->count() == 0)
            <div class="alert alert-info">No courses available.</div>
        @else
            <div class="row">
                @foreach($courses as $course)
                    <div class="col-xl-4 col-lg-6 col-md-6 mb-3">
                        <a href="{{ route('driver.courses', $course->id) }}" class="text-decoration-none">
                            <div class="card custom-card h-100">
                                <div class="card-body">
                                    <h5 class="mb-2">{{ $course->title }}</h5>
                                    @if(!empty($course->description))
                                        <p class="text-muted mb-0">
                                            {{ \Illuminate\Support\Str::limit($course->description, 120) }}
                                        </p>
                                    @endif
                                </div>
                                <div class="card-footer d-flex justify-content-between align-items-center">
                                    <span class="text-muted">Course #{{ $course->order_index }}</span>
                                    <span class="btn btn-sm btn-primary">View</span>
                                </div>
                            </div>
                        </a>
                    </div>
                @endforeach
            </div>
        @endif
    </div>
</div>
@endsection
