{{-- resources/views/admin/sp-modules/courses/index.blade.php --}}
@extends('admin.layout.main')
@section('content')
<div class="main-content app-content">
    <div class="container-fluid">

        <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
            <div>
                <h1 class="page-title fw-medium fs-18 mb-2">{{ $title }}</h1>
            </div>
            <div>
                <a href="{{ route('quiz_question.add') }}" class="btn btn-primary">Add Quiz</a>
            </div>
        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card custom-card">
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <select id="courseFilter" class="form-select">
                                    <option value="">All Courses</option>
                                    @foreach($courses as $course)
                                    <option value="{{ $course->title }}">{{ $course->title }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table id="data-table" class="table table-bordered text-nowrap w-100">
                                <thead>
                                    <tr>
                                        <th>SNO</th>
                                        <th>COURSE</th>
                                        <th>QUESTION</th>
                                        <th>TYPE</th>
                                        <th>POINTS</th>
                                        <th>ORDER</th>
                                        <th>ACTIVE</th>
                                        <th>ACTIONS</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

@section('scripts')
<script src="{{ asset('admin/custom-js/modules-helper.js') }}"></script>
<script src="{{ asset('admin/custom-js/modules.js') }}"></script>
@endsection
@endsection