{{-- resources/views/admin/sp-modules/courses/add.blade.php --}}
@extends('admin.layout.main')
@section('content')
<div class="main-content app-content">
    <div class="container-fluid">

        {{-- Page Header --}}
        <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
            <h1 class="page-title fw-medium fs-18 mb-2">{{ $title }}</h1>
            <a href="{{ route('courses.index') }}" class="btn btn-secondary">Back</a>
        </div>

        {{-- Form Card --}}
        <div class="row">
            <div class="col-xl-12">
                <div class="card custom-card">
                    <div class="card-body">
                        <form method="POST" action="{{ route('quiz_question.store') }}" data-parsley-validate>
                            @csrf

                            {{-- Question Details --}}
                            <div class="row mb-4">
                                <div class="col-md-6 mb-3">
                                    <label for="course_id">Course <span class="text-danger">*</span></label>
                                    <select name="course_id" id="course_id" class="form-control" required>
                                        <option value="">-- Select Course --</option>
                                        @foreach ($courses as $course)
                                        <option value="{{ $course->id }}">{{ $course->title }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label for="order_index">Order Index</label>
                                    <input type="number" id="order_index" name="order_index" class="form-control" value="1" min="1">
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label for="points">Points</label>
                                    <input type="number" id="points" name="points" class="form-control" value="1" min="1">
                                </div>

                                <div class="col-md-12 mb-3">
                                    <label for="question_text">Question <span class="text-danger">*</span></label>
                                    <textarea name="question_text" id="question_text" class="form-control" rows="3" required></textarea>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label for="question_type">Question Type</label>
                                    <select name="question_type" id="question_type" class="form-control">
                                        <option value="mcq_single">MCQ (Single Correct)</option>
                                        <option value="multi_select">Multi Select</option>
                                        <option value="true_false">True / False</option>
                                    </select>
                                </div>

                                <div class="col-md-8 mb-3">
                                    <label for="explanation_text">Explanation</label>
                                    <textarea name="explanation_text" id="explanation_text" class="form-control" rows="2"></textarea>
                                </div>
                            </div>

                            <hr>

                            {{-- Options Section --}}
                            <div id="options-section">
                                <h5>Answer Options</h5>
                                <div id="options-wrapper"></div>
                                <button type="button" id="add-option-btn" class="btn btn-sm btn-secondary mt-2" onclick="addOption()">
                                    + Add Option
                                </button>
                            </div>

                            <hr>

                            <button type="submit" class="btn btn-primary">Save Quiz Question</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

{{-- JS for Dynamic Options --}}
<script>
    let optionIndex = 0;

    function renderOptions(type) {
        const wrapper = document.getElementById('options-wrapper');
        const addBtn = document.getElementById('add-option-btn');

        wrapper.innerHTML = '';
        optionIndex = 0;

        if (type === 'true_false') {
            addBtn.style.display = 'none';
            ['True', 'False'].forEach((text, i) => {
                wrapper.insertAdjacentHTML('beforeend', `
                    <div class="row mb-2">
                        <div class="col-md-7">
                            <input type="text" class="form-control" name="options[${i}][option_text]" value="${text}" readonly>
                        </div>
                        <div class="col-md-2 text-center">
                            <input type="radio" name="is_correct" value="${i}" required> Correct
                        </div>
                    </div>
                `);
            });
            optionIndex = 2;
            return;
        }

        addBtn.style.display = 'inline-block';
        addOption();
        addOption();
    }

    function addOption() {
        const type = document.getElementById('question_type').value;
        const wrapper = document.getElementById('options-wrapper');

        let correctInput = (type === 'mcq_single') ?
            `<input type="radio" name="correct_single" value="${optionIndex}" required>` :
            `<input type="checkbox" name="options[${optionIndex}][is_correct]" value="1">`;

        wrapper.insertAdjacentHTML('beforeend', `
            <div class="row mb-2 align-items-center option-row" data-index="${optionIndex}">
                <div class="col-md-6">
                    <input type="text" name="options[${optionIndex}][option_text]" class="form-control" placeholder="Option ${optionIndex + 1}" required>
                </div>
                <div class="col-md-2 text-center">${correctInput} Correct</div>
                <div class="col-md-3">
                    <input type="text" name="options[${optionIndex}][feedback_if_selected]" class="form-control" placeholder="Feedback">
                </div>
                <div class="col-md-1 text-center">
                    <button type="button" class="btn btn-sm btn-danger" onclick="removeOption(this)">✕</button>
                </div>
            </div>
        `);

        optionIndex++;
    }

    function removeOption(btn) {
        btn.closest('.option-row').remove();
    }

    document.getElementById('question_type').addEventListener('change', function() {
        renderOptions(this.value);
    });

    renderOptions(document.getElementById('question_type').value);
</script>
@endsection