{{-- resources/views/admin/sp-modules/courses/edit.blade.php --}}
@extends('admin.layout.main')
@section('content')
<div class="main-content app-content">
    <div class="container-fluid">

        <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
            <div>
                <h1 class="page-title fw-medium fs-18 mb-2">{{$title}}</h1>
            </div>
            <div>
                <a href="{{ route('courses.index') }}" class="btn btn-secondary">Back</a>
            </div>
        </div>

        <div class="row">
            <div class="col-xl-12">
                <div class="card custom-card">
                    <div class="card-body">
                        <form method="POST" enctype="multipart/form-data" action="{{ route('courses.update', ['id' => $course->id]) }}" data-parsley-validate>
                            @csrf

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label>Program (optional)</label>
                                    <select name="program_id" class="form-control">
                                        <option value="">-- Select Program --</option>
                                        @foreach($programs as $p)
                                            <option value="{{ $p->id }}" {{ $course->program_id == $p->id ? 'selected' : '' }}>
                                                {{ $p->title }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>Order Index</label>
                                    <input type="number" name="order_index" class="form-control" value="{{ $course->order_index }}" min="1" required>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>Title</label>
                                    <input type="text" name="title" class="form-control" value="{{ $course->title }}" required>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>Description</label>
                                    <input type="text" name="description" class="form-control" value="{{ $course->description }}">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>Video URL</label>
                                    <input type="text" name="video_url" class="form-control" value="{{ $course->video_url }}">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>Slides URL (optional link)</label>
                                    <input type="text" name="slides_url" class="form-control" value="{{ $course->slides_url }}" placeholder="Optional: Google Drive / URL">
                                </div>

                                <div class="col-md-12 mb-3">
                                    <label>Transcript</label>
                                    <textarea name="transcript" id="transcript_editor" class="form-control" rows="6">{!! $course->transcript !!}</textarea>
                                </div>

                                <div class="col-md-12 mb-3">
                                    <label>Upload Files (PPT / Word / Excel / PDF)</label>
                                    <input type="file" name="attachments[]" class="form-control" multiple
                                           accept=".pdf,.ppt,.pptx,.doc,.docx,.xls,.xlsx">
                                    <small class="text-muted">You can select multiple files.</small>
                                </div>


                                <div class="col-md-4 mb-3">
                                    <label>Has Quiz</label>
                                    <select name="has_quiz" class="form-control">
                                        <option value="0" {{ $course->has_quiz ? '' : 'selected' }}>No</option>
                                        <option value="1" {{ $course->has_quiz ? 'selected' : '' }}>Yes</option>
                                    </select>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label>Passing Percent</label>
                                    <input type="number" name="passing_percent" class="form-control" min="0" max="100" value="{{ $course->passing_percent }}">
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label>Unlimited Attempts</label>
                                    <select name="allow_unlimited_attempts" class="form-control">
                                        <option value="1" {{ $course->allow_unlimited_attempts ? 'selected' : '' }}>Yes</option>
                                        <option value="0" {{ $course->allow_unlimited_attempts ? '' : 'selected' }}>No</option>
                                    </select>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label>Max Attempts</label>
                                    <input type="number" name="max_attempts" class="form-control" min="1" value="{{ $course->max_attempts }}">
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label>Unlock Type</label>
                                    <select name="unlock_type" class="form-control" required>
                                        <option value="open" {{ $course->unlock_type == 'open' ? 'selected' : '' }}>Open</option>
                                        <option value="after_prerequisite" {{ $course->unlock_type == 'after_prerequisite' ? 'selected' : '' }}>After Prerequisite</option>
                                    </select>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label>Prerequisite Course</label>
                                    <select name="prerequisite_course_id" class="form-control">
                                        <option value="">-- None --</option>
                                        @foreach($courses as $c)
                                            <option value="{{ $c->id }}" {{ $course->prerequisite_course_id == $c->id ? 'selected' : '' }}>
                                                {{ $c->title }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label>Prerequisite Condition</label>
                                    <select name="prerequisite_condition" class="form-control" required>
                                        <option value="completed" {{ $course->prerequisite_condition == 'completed' ? 'selected' : '' }}>Completed</option>
                                        <option value="passed" {{ $course->prerequisite_condition == 'passed' ? 'selected' : '' }}>Passed</option>
                                    </select>
                                </div>
                            </div>

                            <button type="submit" class="btn btn-primary">Update</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
    @section('scripts')
        <script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script> 
        <script> 
           ClassicEditor .create(document.querySelector('#transcript_editor'), { toolbar: [ 'heading','|', 'bold','italic','underline','|', 'bulletedList','numberedList','|', 'link','insertTable','|', 'undo','redo' ] }) .catch(error => { console.error(error); }); 
        </script>
        @if (session('success'))
            <script>
                notify('success', @json(session('success')));
            </script>
        @endif

        @if ($errors->any())
            <script>
                notify('danger', @json($errors->first()));
            </script>
        @endif
    @endsection
@endsection
