{{-- resources/views/admin/sp-modules/courses/add.blade.php --}}
@extends('admin.layout.main')
@section('content')
<div class="main-content app-content">
    <div class="container-fluid">

        <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
            <div>
                <h1 class="page-title fw-medium fs-18 mb-2">{{$title}}</h1>
            </div>
            <div>
                <a href="{{ route('courses.index') }}" class="btn btn-secondary">Back</a>
            </div>
        </div>

        <div class="row">
            <div class="col-xl-12">
                <div class="card custom-card">
                    <div class="card-body">
                        <form method="POST" enctype="multipart/form-data" action="{{ route('courses.store') }}" data-parsley-validate>
                            @csrf

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label>Program (optional)</label>
                                    <select name="program_id" class="form-control">
                                        <option value="">-- Select Program --</option>
                                        @foreach($programs as $p)
                                            <option value="{{ $p->id }}">{{ $p->title }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>Order Index</label>
                                    <input type="number" name="order_index" class="form-control" value="1" min="1" required>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>Title</label>
                                    <input type="text" name="title" class="form-control" required>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>Description</label>
                                    <input type="text" name="description" class="form-control">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>Video URL</label>
                                    <input type="text" name="video_url" class="form-control">
                                </div>

                                
                                <div class="col-md-6 mb-3">
                                    <label>Slides URL (optional link)</label>
                                    <input type="text" name="slides_url" class="form-control" placeholder="Optional: Google Drive / URL">
                                </div>

                                <div class="col-md-12 mb-3">
                                    <label>Transcript</label>
                                    <textarea name="transcript" id="transcript_editor" class="form-control" rows="6"></textarea>
                                </div>

                                <div class="col-md-12 mb-3">
                                    <label>Upload Files (PPT / Word / Excel / PDF)</label>
                                    <input type="file" name="attachments[]" class="form-control" multiple
                                           accept=".pdf,.ppt,.pptx,.doc,.docx,.xls,.xlsx">
                                    <small class="text-muted">You can select multiple files.</small>
                                </div>


                                <div class="col-md-4 mb-3">
                                    <label>Has Quiz</label>
                                    <select name="has_quiz" class="form-control">
                                        <option value="0">No</option>
                                        <option value="1">Yes</option>
                                    </select>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label>Passing Percent (default 95)</label>
                                    <input type="number" name="passing_percent" class="form-control" min="0" max="100" placeholder="95">
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label>Unlimited Attempts</label>
                                    <select name="allow_unlimited_attempts" class="form-control">
                                        <option value="1">Yes</option>
                                        <option value="0">No</option>
                                    </select>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label>Max Attempts (only if unlimited = No)</label>
                                    <input type="number" name="max_attempts" class="form-control" min="1">
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label>Unlock Type</label>
                                    <select name="unlock_type" class="form-control" required>
                                        <option value="open">Open</option>
                                        <option value="after_prerequisite">After Prerequisite</option>
                                    </select>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label>Prerequisite Course</label>
                                    <select name="prerequisite_course_id" class="form-control">
                                        <option value="">-- None --</option>
                                        @foreach($courses as $c)
                                            <option value="{{ $c->id }}">{{ $c->title }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label>Prerequisite Condition</label>
                                    <select name="prerequisite_condition" class="form-control" required>
                                        <option value="completed">Completed</option>
                                        <option value="passed">Passed</option>
                                    </select>
                                </div>

                            </div>

                            <button type="submit" class="btn btn-primary">Save</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

   @section('scripts')
        <script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script> 
        <script> 
           ClassicEditor .create(document.querySelector('#transcript_editor'), { toolbar: [ 'heading','|', 'bold','italic','underline','|', 'bulletedList','numberedList','|', 'link','insertTable','|', 'undo','redo' ] }) .catch(error => { console.error(error); }); 
        </script>
    @endsection
@endsection
