@extends('admin.layout.main')
@section('content')
<div class="main-content app-content">
    <div class="container-fluid">

        <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
            <div>
                <h1 class="page-title fw-medium fs-18 mb-2">{{$title}}</h1>
            </div>
        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card custom-card">
                    <div class="card-body">
                        @php
                            if(isset($blog->id)){
                                $formurl = route('admin.add_edit_blog',['id' => $blog->id]);
                            }else{
                                $formurl = route('admin.add_edit_blog');
                            }
                        @endphp
                        <form id="add-edit-blog" data-parsley-validate data-url="{{ $formurl }}">
                            <div class="form-group col-6 mb-3">
                                <label for="floatingInput">Title <span class="text-danger">*</span></label>
                                <input type="text" placeholder="Enter Title" minlength="3" maxlength="50" name="title" value="{{ isset($blog->title) ? $blog->title :"" }}" class="form-control" id="title" required="true">
                            </div>
                            <div class="form-group col-6 mb-3">
                                <label for="floatingInput">Tags <span class="text-danger">*</span></label>
                                <input type="text" placeholder="Enter tags" minlength="3" maxlength="50" name="tags" value="{{ isset($blog->tags) ? $blog->tags :"" }}" class="form-control" id="title" required="true">
                            </div>
                            <div class="form-group col-6 mb-3">
                                <label for="floatingInput">Short Description <span class="text-danger">*</span></label>
                                <textarea name="short_desc" class="form-control" placeholder="Enter Short Description" id="description" required minlength="10">{{ isset($blog->short_desc) ? $blog->short_desc : "" }}</textarea>
                            </div>
                            <div class="form-group col-6 mb-3">
                                <label for="floatingInput">Select Category <span class="text-danger">*</span></label>
                                <select class="form-control" id="category" data-toggle="select2" data-placeholder="Select Category" name="category_id" aria-hidden="true">
                                    @foreach ($categories as $category)
                                        <option {{ isset($blog->category_id) && $blog->category_id == $category->id ? 'selected' : "" }} value="{{ $category->id }}">{{ $category->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-6 mb-3">
                                <label for="floatingInput">Thumbnail <span class="text-danger">*</span></label>
                                <input type="file" name="thumbnail" class="form-control" id="thumbnail" {{ !isset($blog->thumbnail) ? 'required' : ''  }}>
                            </div>
                            <div class="form-group col-6 mb-3">
                                <label for="floatingInput">Meta Title <span class="text-danger">*</span></label>
                                <input type="text" value="{{ isset($blog->meta_title) ? $blog->meta_title :"" }}" placeholder="Enter Meta Title" minlength="3" maxlength="50" name="meta_title" class="form-control" id="meta_title" required="true">
                            </div>
                            <div class="form-group col-6 mb-3">
                                <label for="floatingInput">Meta Description <span class="text-danger">*</span></label>
                                <input type="text" value="{{ isset($blog->meta_desc) ? $blog->meta_desc :"" }}" placeholder="Meta Description" minlength="3" maxlength="50" name="meta_desc" class="form-control" id="meta_desc" required="true">
                            </div>
                            <div class="form-group col-12 mb-3">
                                <div id="editor">
                                    @if (isset($blog->blog_desc))
                                    {!! $blog->blog_desc !!}
                                    @else
                                        <h4>Write something awsome</h4>
                                    @endif
                                </div>
                            </div>
                            <div class="col-12 float-right">
                                <button id="add-btn" onclick="save_form(event,this)" class="btn btn-primary">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@section('scripts')
<link rel="stylesheet" href="{{ asset('admin/libs/quill/quill.snow.css')}}">
<link rel="stylesheet" href="{{ asset('admin/libs/quill/quill.bubble.css')}}">

<script src="{{ asset('admin/libs/quill/quill.js') }}"></script>
<script src="{{ asset('admin/custom-js/blogs.js') }}"></script>
@endsection
@endsection