let generate_lead = (e, element) => {
    e.preventDefault();
    var title = $('#add-btn').html();
    var route = $("#lead-form").data('url');
    $('#add-btn').html('Please wait...');
    e.preventDefault();
    var formdata = new FormData($("#lead-form")[0]);
    $.ajax({
        url: route,
        type: "POST",
        data: formdata,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 8000000,
        success: function (result) {
            if (result.status == 1) {
                notify("success", result.msg);
            }
            if (result.status == 0) {
                notify("danger", "Error", result.msg);
            }
            $('#add-btn').html(title);
        },
        error: function (xhr, err) {
            var errorMessage = xhr.responseJSON.message;
            notify("danger", errorMessage);
            $('#add-btn').html(title);
        }
    });
    
}

let notify = (type, title, desc="") => {
    let config = {
        success: {
            color: "linear-gradient(to right, #00b09b, #96c93d)",
        },
        danger: {
            color: "linear-gradient(to right, #ff5f6d, #d63031)",
        },
        warning: {
            color: "linear-gradient(to right, #f7b733, #fc4a1a)",
        }
    };
    let selected = config[type] || config.success;
    Toastify({
        text: `<b>${title}</b><br>${desc}`,
        duration: 3000,
        close: true,
        gravity: "bottom",
        position: "right",
        stopOnFocus: true,
        escapeMarkup: false,
        style: {
            background: selected.color,
        }
    }).showToast();
};