$(document).ready(function(){
    var toolbarOptions = [
        [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
        [{ 'font': [] }],
        ['bold', 'italic', 'underline', 'strike'],        // toggled buttons
        ['blockquote', 'code-block'],
    
        [{ 'header': 1 }, { 'header': 2 }],               // custom button values
        [{ 'list': 'ordered' }, { 'list': 'bullet' }],
        [{ 'script': 'sub' }, { 'script': 'super' }],      // superscript/subscript
        [{ 'indent': '-1' }, { 'indent': '+1' }],          // outdent/indent
        [{ 'direction': 'rtl' }],                         // text direction
    
        [{ 'size': ['small', false, 'large', 'huge'] }],  // custom dropdown
    
        [{ 'color': [] }, { 'background': [] }],          // dropdown with defaults from theme
        [{ 'align': [] }],
    
        ['image', 'video'],
        ['clean']                                         // remove formatting button
    ];
    
    window.quill = new Quill('#editor', {
        modules: {
            toolbar: toolbarOptions
        },
        theme: 'snow'
    });
});

let save_form = (e, element) => {
    e.preventDefault();
    var title = $(element).html()
    var forms = $("#add-edit-details");
    var route = $("#add-edit-details").data('url');
    forms.parsley().validate();
    initLoader('add-btn','','btn-primary');
    if (!forms.parsley().isValid()) {
        destroyLoader('add-btn',title,'btn-primary')
        return false;
    }
    console.log(title);
    
    e.preventDefault();
    if (forms.parsley().isValid()) {
        var formdata = new FormData($("#add-edit-details")[0]);
        formdata.append('details_content', quill.root.innerHTML);
        $.ajax({
            url: route,
            type: "POST",
            data: formdata,
            processData: false,
            contentType: false,
            cache: false,
            timeout: 8000000,
            success: function (result) {
                if (result.status == 1) {
                    notify("success", result.msg);
                    window.location.href = '/admin/child-services';
                    destroyLoader('add-btn',title,'btn-primary')
                }
                if (result.status == 0) {
                    notify("danger", "Error", result.msg);
                    destroyLoader('add-btn', title, 'btn-primary')
                }
            },
            error: function (xhr, err) {
                var errorMessage = xhr.responseJSON.message;
                notify("danger", errorMessage);
                destroyLoader('add-btn', title, 'btn-primary')
            }
        });
    }
}

$(document).on('click', '.edit-item', function () {
    var title = $(this).html();
    var btn_id = $(this).attr('id');
    var route = $(this).data('route');
    initLoader(btn_id, title, 'btn', 'S')
    $.ajax({
        url: route,
        type: "POST",
        data: {
            type: "modal",
        },
        success: function (result) {
            if (result.status == 1) {
                $("#edit-modal").modal("show");
                $("#edit-form").html(result.payload);
                destroyLoader(btn_id, title, 'btn', 'S')
            }
            if (result.status == 0) {
                notify("danger", "Error", result.message);
                destroyLoader(btn_id, title, 'btn', 'S')
            }
        },
        error: function (xhr, err) {
            var errorMessage = xhr.responseJSON.message;
            notify("danger", errorMessage);
            destroyLoader(btn_id, title, 'btn', 'S')
        }
    });
});

let update_form = (e, element) => {
    var form_id = $(element).closest('.modal-content').find('form').attr('id');
    var title = $(element).html()
    var forms = $("#" + form_id);
    var route = $("input[name='edit_url']").val();

    forms.parsley().validate();
    initLoader('update-btn', '', 'btn-primary');
    if (!forms.parsley().isValid()) {
        destroyLoader('update-btn', title, 'btn-primary')
        return false;
    }
    e.preventDefault();
    if (forms.parsley().isValid()) {
        var formdata = new FormData($("#" + form_id)[0]);
        formdata.append('type', 'edit');
        $.ajax({
            url: route,
            type: "POST",
            data: formdata,
            processData: false,
            contentType: false,
            cache: false,
            timeout: 8000000,
            success: function (result) {
                if (result.status == 1) {
                    notify("success", result.msg);
                    $("#edit-modal").modal("hide");
                    $("#" + form_id)[0].reset();
                    $("#data-table").DataTable().ajax.reload();
                    destroyLoader('update-btn', title, 'btn-primary')
                }
                if (result.status == 0) {
                    notify("danger", "Error", result.msg);
                    destroyLoader('update-btn', title, 'btn-primary')
                }
            },
            error: function (xhr, err) {
                var errorMessage = xhr.responseJSON.message;
                notify("danger", errorMessage);
                destroyLoader('update-btn', title, 'btn-primary')
            }
        });
    }
}