<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quiz_options', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('question_id');
            $table->text('option_text');
            $table->boolean('is_correct', ['1', '0'])->default('1');
            $table->text('feedback_if_selected')->nullable();
            $table->unsignedInteger('order_index')->default(1);
            $table->enum('is_active', ['1', '0'])->default('1');
            $table->enum('is_deleted', ['Y', 'N'])->default('N');
            $table->timestamps();
            $table->foreign('question_id')->references('id')->on('quiz_questions')->onDelete('cascade');
          
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quiz_options');
    }
};
