<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('courses', function (Blueprint $table) {
            $table->id();

            // Program relation
            $table->foreignId('program_id')
                  ->nullable()
                  ->constrained('programs')
                  ->nullOnDelete();

            // Basic info
            $table->string('title', 255);
            $table->text('description')->nullable();
            $table->unsignedInteger('order_index')->default(1);

            // Content
            $table->text('video_url')->nullable();
            $table->text('slides_url')->nullable();
            $table->longText('transcript')->nullable();

            // Quiz configuration
            $table->boolean('has_quiz')->default(false);
            $table->unsignedTinyInteger('passing_percent')->nullable();
            $table->boolean('allow_unlimited_attempts')->default(true);
            $table->unsignedInteger('max_attempts')->nullable();

            // Unlock configuration
            $table->enum('unlock_type', ['open', 'after_prerequisite'])
                  ->default('open');

            $table->foreignId('prerequisite_course_id')
                  ->nullable()
                  ->constrained('courses')
                  ->nullOnDelete();

            $table->enum('prerequisite_condition', ['completed', 'passed'])
                  ->default('completed');

            // Status
            $table->enum('is_active', ['1','0'])->default('1');
            $table->enum('is_deleted', ['Y','N'])->default('N');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('courses');
    }
};
