<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class QuizQuestion extends Model
{
    protected $table = 'quiz_questions';

    protected $fillable = [
        'course_id',
        'question_text',
        'question_type',
        'explanation_text',
        'points',
        'order_index',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'points' => 'integer',
        'order_index' => 'integer',
    ];


    public function course()
    {
        return $this->belongsTo(Courses::class);
    }
    
   public function options()
    {
        return $this->hasMany(QuizOption::class, 'question_id')->where('is_deleted', 'N')->orderBy('order_index');
    }


}

