<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class QuizOption extends Model
{
    protected $table = 'quiz_options';

    protected $fillable = [
        'question_id',
        'option_text',
        'is_correct',
        'feedback_if_selected',
        'order_index',
        'is_active',
        'is_deleted',
    ];

    protected $casts = [
        'is_correct' => 'boolean',
        'order_index' => 'integer',
    ];

    /**
     * Option belongs to a quiz question
     */
    public function question()
    {
        return $this->belongsTo(QuizQuestion::class, 'question_id');
    }
}
