<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Enrollments extends Model
{
    protected $fillable = [
        'user_id',
        'program_id',
        'course_id',
        'status',
        'started_at',
        'completed_at'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function program()
    {
        return $this->belongsTo(Programs::class);
    }

    public function course()
    {
        return $this->belongsTo(Courses::class);
    }
}
