<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class LeadsMail extends Mailable
{
    use Queueable, SerializesModels;

    public $params;

    public function __construct($params)
    {
        $this->params  = $params;
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Thank You For Contacting Thirdot',
        );
    }

    public function content(): Content
    {
        return new Content(
        view: 'email.leads',
        with: [
            'params' => $this->params
        ]
    );
    }
}

