<?php

namespace App\Http\Controllers\Dirver;

use App\Http\Controllers\Controller;
use Http;
use Illuminate\Http\Request;

class TextToSpeachController extends Controller
{
    public function tts(Request $request)
    {
        $request->validate([
            'text' => 'required|string|max:50000',
        ]);

        $apiKey = config('services.audixa.key');
        $base = 'https://api.audixa.ai/v3';

        // 1) Create generation
        $create = Http::timeout(30)->withHeaders([
            'x-api-key' => $apiKey,
            'Accept' => 'application/json',
            'Content-Type' => 'application/json',
        ])->post($base.'/tts', [
            'text' => $request->text,
            'voice_id' => 'am_ethan',     // change voice_id if you want
            'model' => 'base',
            'speed' => 1.0,
            'audio_format' => 'mp3',
        ]);

        if (! $create->successful()) {
            return response()->json([
                'status' => 0,
                'msg' => 'Audixa create failed',
                'payload' => ['error' => $create->json()],
            ], 422);
        }

        $genId = data_get($create->json(), 'generation_id');
        if (! $genId) {
            return response()->json([
                'status' => 0,
                'msg' => 'generation_id not returned',
                'payload' => ['response' => $create->json()],
            ], 422);
        }

        // 2) Poll status until COMPLETED
        $audioUrl = null;
        $status = null;

        for ($i = 0; $i < 25; $i++) { // ~12.5 seconds if 0.5s sleep
            usleep(500000);

            $check = Http::timeout(30)->withHeaders([
                'x-api-key' => $apiKey,
                'Accept' => 'application/json',
            ])->get($base.'/tts', [
                'generation_id' => $genId,
            ]);

            if (! $check->successful()) {
                continue;
            }

            $status = data_get($check->json(), 'status');
            if ($status === 'FAILED') {
                return response()->json([
                    'status' => 0,
                    'msg' => 'TTS generation failed',
                    'payload' => ['error_message' => data_get($check->json(), 'error_message'), 'data' => $check->json()],
                ], 422);
            }

            if ($status === 'COMPLETED') {
                $audioUrl = data_get($check->json(), 'audio_url');
                break;
            }
        }

        if (! $audioUrl) {
            return response()->json([
                'status' => 0,
                'msg' => 'TTS not ready yet (timeout)',
                'payload' => ['generation_id' => $genId, 'last_status' => $status],
            ], 422);
        }

        // 3) Download audio bytes from audio_url
        $audio = Http::timeout(60)->get($audioUrl);
        if (! $audio->successful()) {
            return response()->json([
                'status' => 0,
                'msg' => 'Failed to download audio',
                'payload' => ['audio_url' => $audioUrl],
            ], 422);
        }

        return response($audio->body(), 200)
            ->header('Content-Type', 'audio/mpeg');
    }
}
