<?php

namespace App\Http\Controllers\Dirver;

use App\Http\Controllers\Controller;
use App\Models\Courses;
use App\Models\QuizOption;
use App\Models\QuizQuestion;
use Illuminate\Http\Request;

class CoursesListCountroller extends Controller
{
    public function courses($id = null)
    {
        if ($id == null) {
            $title = 'Training Courses';

            $courses = Courses::where('is_deleted', 'N')
                ->where('is_active', '1')
                ->orderBy('order_index', 'asc')
                ->get();

            return view('driver.courses.index', compact('title', 'courses'));
        } else {
            $course = Courses::where('is_deleted', 'N')
                ->where('is_active', '1')
                ->with('files')
                ->findOrFail($id);
            $title = $course->title;
            $quiz = QuizQuestion::where('course_id', $id)->where('is_deleted', 'N')->where('is_active', '1')->get();
            return view('driver.courses.single-show', compact('title', 'course', 'quiz'));
        }
    }
    public function submitQuiz(Request $request)
    {
        if (!$request->has('answers')) {
            return back()->with('error', 'Please attempt the quiz.');
        }

        $answers = $request->answers;

        $correct = 0;
        $wrong   = 0;
        $details = [];

        $totalPoints = 0;
        $earnedPoints = 0;

        foreach ($answers as $questionId => $selectedOptions) {

            if (!is_array($selectedOptions)) {
                $selectedOptions = [$selectedOptions];
            }

            $question = QuizQuestion::find($questionId);
            if (!$question) continue;

            // 🔢 add question points to total
            $totalPoints += $question->points;

            $correctOptions = QuizOption::where('question_id', $questionId)
                ->where('is_correct', 1)
                ->pluck('id')
                ->toArray();

            sort($selectedOptions);
            sort($correctOptions);

            if ($selectedOptions == $correctOptions) {
                $correct++;
                $earnedPoints += $question->points; // ✅ add earned points
                $status = 'Correct';
            } else {
                $wrong++;
                $status = 'Wrong';
            }

            $details[] = [
                'question' => $question->question_text,
                'status'   => $status,
                'points'   => $question->points
            ];
        }

        // 🎯 Percentage calculation
        $percentage = $totalPoints > 0
            ? round(($earnedPoints / $totalPoints) * 100, 2)
            : 0;

        // 🎓 Course passing percentage
        $course = Courses::where('is_active', '1')->first(); // ya course_id se lo
        $passingPercent = $course->passing_percent ?? 50;

        // ✅ PASS / FAIL
        $resultStatus = $percentage >= $passingPercent ? 'PASS' : 'FAIL';

        return view('driver.courses.quiz-report', [
            'title'           => 'Quiz Result',
            'correct'         => $correct,
            'wrong'           => $wrong,
            'total'           => $correct + $wrong,
            'details'         => $details,
            'earnedPoints'    => $earnedPoints,
            'totalPoints'     => $totalPoints,
            'percentage'      => $percentage,
            'passingPercent'  => $passingPercent,
            'resultStatus'    => $resultStatus
        ]);
    }

}
