<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{
    public function login(Request $request)
    {
        if ($request->isMethod("GET")) {
            $title = "Login";
            return view("admin.auth.login", compact("title"));
        }
        if ($request->isMethod("POST")) {
            $request->validate([
                'email' => 'required|email',
                'password' => 'required|min:6'
            ]);
            $credentials = $request->only('email', 'password');

            if (Auth::attempt($credentials)) {
                $request->session()->regenerate();
                $user = Auth::user();

                if ($user->role === 'driver') {
                    return redirect()->intended('/lms/dashboard')
                        ->with('success', 'Login successful!');
                }

                return redirect()->intended('/lms/management/dashboard')
                    ->with('success', 'Login successful!');
            }

            return back()->withErrors([
                'email' => 'The provided credentials do not match our records.',
            ])->onlyInput('email');
        }
    }
}
