<?php

use App\Models\Blogs;
use App\Models\Services;
use Illuminate\Support\Str;

if (!function_exists('list_routes')) {
    function list_routes()
    {
        $routes = array();
        return true;
    }
}

if (!function_exists('image_upload')) {
    function image_upload($image, $path)
    {
        if (!$image) {
            return false;
        }
        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }
        $imageName = Str::random(6) . '.' . $image->getClientOriginalExtension();
        if ($image->move($path, $imageName)) {
            return $imageName;
        }
        return false;
    }
}

if (!function_exists('compressJson')) {
    function compressJson($array)
    {
        $json = json_encode($array);
        $compress = gzencode($json, 9);
        header('Content-Encoding: gzip');
        return $compress;
    }
}

if(!function_exists('services')){
    function services(){
        $ser = Services::where('status', '1')->with(['child_services'])->where('is_deleted', 'N')->get();
        return $ser;
    }
}
if(!function_exists('latest_blogs')){
    function latest_blogs(){
        $blg = Blogs::where('status', '1')->where('is_deleted', 'N')->get();
        return $blg;
    }
}